package gov.va.med.mhv.bluebutton.web.bean;

import java.io.Serializable;

import javax.el.ValueExpression;
import javax.faces.bean.ManagedBean;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;

import org.primefaces.component.datatable.DataTable;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@ManagedBean
@Component
@Scope("session")
public class StudyTableBean implements Serializable {
	private static final long serialVersionUID = -7104137024976940737L;

	private static final String ROWS_PER_PAGE = "LIFERAY_SHARED_rowsperpage";

	private DataTable studyTable;
	protected ValueExpression sortColumn;
	protected String sortBy;
	protected Integer rowsPerPage = -1;
	
	public DataTable getStudyTable() {
		return studyTable;
	}
	
	public void setStudyTable(DataTable studyTable) {
		this.studyTable = studyTable;
	}
	
	public ValueExpression getSortColumn() {
		return sortColumn;
	}
	
	public void setSortColumn(ValueExpression sortColumn) {
		this.sortColumn = sortColumn;
	}
	
	public String getSortBy() {
		return sortBy;
	}
	
	public void setSortBy(String sortBy) {
		this.sortBy = sortBy;
	}
	
	public int getRowsPerPage() {
		if (rowsPerPage == null || rowsPerPage < 0) {
			// Init rowsPerPage from portlet session variable if possible
			try {
				PortletRequest request = (PortletRequest) FacesContext.getCurrentInstance().getExternalContext().getRequest();
				PortletSession session = request.getPortletSession();
				rowsPerPage = (Integer) session.getAttribute(ROWS_PER_PAGE, PortletSession.PORTLET_SCOPE);
			} catch (Exception e) {
				rowsPerPage = 10;
			}
		}
		return (rowsPerPage != null && rowsPerPage > 0) ? rowsPerPage : 10;
	}
	
	public void setRowsPerPage(int rowsPerPage) {
		this.rowsPerPage = rowsPerPage;
	}
}
